/*
 * Decompiled with CFR 0.152.
 */
package ttv.migami.jeg.item;

import java.util.List;
import java.util.Locale;
import java.util.Objects;
import java.util.WeakHashMap;
import java.util.function.Consumer;
import javax.annotation.Nullable;
import net.minecraft.ChatFormatting;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.renderer.BlockEntityWithoutLevelRenderer;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.level.Level;
import net.minecraftforge.client.extensions.common.IClientItemExtensions;
import net.minecraftforge.registries.ForgeRegistries;
import ttv.migami.jeg.JustEnoughGuns;
import ttv.migami.jeg.client.GunItemStackRenderer;
import ttv.migami.jeg.client.KeyBinds;
import ttv.migami.jeg.common.FireMode;
import ttv.migami.jeg.common.Gun;
import ttv.migami.jeg.common.ModTags;
import ttv.migami.jeg.common.NetworkGunManager;
import ttv.migami.jeg.common.ReloadType;
import ttv.migami.jeg.debug.Debug;
import ttv.migami.jeg.enchantment.EnchantmentTypes;
import ttv.migami.jeg.init.ModItems;
import ttv.migami.jeg.item.AtlanteanSpearItem;
import ttv.migami.jeg.item.IColored;
import ttv.migami.jeg.item.IMeta;
import ttv.migami.jeg.item.TyphooneeItem;
import ttv.migami.jeg.util.GunEnchantmentHelper;
import ttv.migami.jeg.util.GunModifierHelper;

public class GunItem
extends Item
implements IColored,
IMeta {
    private final WeakHashMap<CompoundTag, Gun> modifiedGunCache = new WeakHashMap();
    private Gun gun = new Gun();

    public GunItem(Item.Properties properties) {
        super(properties);
    }

    public void setGun(NetworkGunManager.Supplier supplier) {
        this.gun = supplier.getGun();
    }

    public Gun getGun() {
        return this.gun;
    }

    public void m_7373_(ItemStack stack, @Nullable Level worldIn, List<Component> tooltip, TooltipFlag flag) {
        if (Screen.m_96638_()) {
            Gun modifiedGun = this.getModifiedGun(stack);
            String fireMode = modifiedGun.getGeneral().getFireMode().getId().toString();
            tooltip.add((Component)Component.m_237115_((String)"info.jeg.fire_mode").m_130940_(ChatFormatting.GRAY).m_7220_((Component)Component.m_237115_((String)("fire_mode." + fireMode)).m_130940_(ChatFormatting.WHITE)));
            Item ammo = (Item)ForgeRegistries.ITEMS.getValue(modifiedGun.getProjectile().getItem());
            Item reloadItem = (Item)ForgeRegistries.ITEMS.getValue(modifiedGun.getReloads().getReloadItem());
            if (modifiedGun.getReloads().getReloadType() == ReloadType.SINGLE_ITEM) {
                ammo = reloadItem;
            }
            if (ammo != null) {
                tooltip.add((Component)Component.m_237110_((String)"info.jeg.ammo_type", (Object[])new Object[]{Component.m_237115_((String)ammo.m_5524_()).m_130940_(ChatFormatting.WHITE)}).m_130940_(ChatFormatting.GRAY));
            }
            Object additionalDamageText = "";
            CompoundTag tagCompound = stack.m_41783_();
            if (tagCompound != null && tagCompound.m_128425_("AdditionalDamage", 99)) {
                float additionalDamage = tagCompound.m_128457_("AdditionalDamage");
                if ((additionalDamage += GunModifierHelper.getAdditionalDamage(stack)) > 0.0f) {
                    additionalDamageText = ChatFormatting.GREEN + " +" + ItemStack.f_41584_.format(additionalDamage);
                } else if (additionalDamage < 0.0f) {
                    additionalDamageText = ChatFormatting.RED + " " + ItemStack.f_41584_.format(additionalDamage);
                }
            }
            float damage = modifiedGun.getProjectile().getDamage();
            ResourceLocation advantage = modifiedGun.getProjectile().getAdvantage();
            damage = GunModifierHelper.getModifiedProjectileDamage(stack, damage);
            damage = GunEnchantmentHelper.getAcceleratorDamage(stack, damage);
            tooltip.add((Component)Component.m_237110_((String)"info.jeg.damage", (Object[])new Object[]{ChatFormatting.WHITE + ItemStack.f_41584_.format(damage) + (String)additionalDamageText}).m_130940_(ChatFormatting.GRAY));
            if (!advantage.equals((Object)ModTags.Entities.NONE.f_203868_())) {
                tooltip.add((Component)Component.m_237115_((String)"info.jeg.advantage").m_130940_(ChatFormatting.GRAY).m_7220_((Component)Component.m_237115_((String)("advantage." + advantage)).m_130940_(ChatFormatting.GOLD)));
            }
            if (tagCompound != null) {
                if (tagCompound.m_128471_("IgnoreAmmo")) {
                    tooltip.add((Component)Component.m_237115_((String)"info.jeg.ignore_ammo").m_130940_(ChatFormatting.AQUA));
                } else {
                    int ammoCount = tagCompound.m_128451_("AmmoCount");
                    tooltip.add((Component)Component.m_237110_((String)"info.jeg.ammo", (Object[])new Object[]{ChatFormatting.WHITE.toString() + ammoCount + "/" + GunModifierHelper.getModifiedAmmoCapacity(stack, modifiedGun)}).m_130940_(ChatFormatting.GRAY));
                }
            }
        } else {
            tooltip.add((Component)Component.m_237115_((String)"info.jeg.shift_tooltip").m_130940_(ChatFormatting.WHITE));
        }
        tooltip.add((Component)Component.m_237110_((String)"info.jeg.attachment_help", (Object[])new Object[]{KeyBinds.KEY_ATTACHMENTS.m_90863_().getString().toUpperCase(Locale.ENGLISH)}).m_130940_(ChatFormatting.YELLOW));
        if (this instanceof TyphooneeItem) {
            tooltip.add((Component)Component.m_237115_((String)"info.jeg.tooltip_item.typhoonee").m_130940_(ChatFormatting.GRAY));
        } else if (this instanceof AtlanteanSpearItem) {
            tooltip.add((Component)Component.m_237115_((String)"info.jeg.tooltip_item.atlantean_spear").m_130940_(ChatFormatting.GRAY));
        }
    }

    public boolean onEntitySwing(ItemStack stack, LivingEntity entity) {
        return true;
    }

    public int m_8105_(ItemStack stack) {
        Gun gun = ((GunItem)stack.m_41720_()).getModifiedGun(stack);
        return gun.getGeneral().getRate() * 4;
    }

    public boolean shouldCauseReequipAnimation(ItemStack oldStack, ItemStack newStack, boolean slotChanged) {
        return slotChanged;
    }

    public boolean m_142522_(ItemStack stack) {
        return stack.m_41768_();
    }

    public int m_142158_(ItemStack stack) {
        CompoundTag tagCompound = stack.m_41784_();
        Gun modifiedGun = this.getModifiedGun(stack);
        return Math.round(13.0f - (float)stack.m_41773_() * 13.0f / (float)this.getMaxDamage(stack));
    }

    public int m_142159_(ItemStack stack) {
        if ((double)stack.m_41773_() >= (double)stack.m_41776_() / 1.5) {
            return Objects.requireNonNull(ChatFormatting.RED.m_126665_());
        }
        float stackMaxDamage = this.getMaxDamage(stack);
        float f = Math.max(0.0f, (stackMaxDamage - (float)stack.m_41773_()) / stackMaxDamage);
        return Mth.m_14169_((float)(f / 3.0f), (float)1.0f, (float)1.0f);
    }

    public Gun getModifiedGun(ItemStack stack) {
        CompoundTag tagCompound = stack.m_41783_();
        if (tagCompound != null && tagCompound.m_128425_("Gun", 10)) {
            return this.modifiedGunCache.computeIfAbsent(tagCompound, item -> {
                if (tagCompound.m_128471_("Custom")) {
                    return Gun.create(tagCompound.m_128469_("Gun"));
                }
                Gun gunCopy = this.gun.copy();
                gunCopy.deserializeNBT(tagCompound.m_128469_("Gun"));
                return gunCopy;
            });
        }
        if (JustEnoughGuns.isDebugging()) {
            return Debug.getGun(this);
        }
        return this.gun;
    }

    public boolean canApplyAtEnchantingTable(ItemStack stack, Enchantment enchantment) {
        if (enchantment.f_44672_ == EnchantmentTypes.SEMI_AUTO_GUN) {
            Gun modifiedGun = this.getModifiedGun(stack);
            return modifiedGun.getGeneral().getFireMode() != FireMode.AUTOMATIC;
        }
        return super.canApplyAtEnchantingTable(stack, enchantment);
    }

    public boolean m_8120_(ItemStack stack) {
        return this.getMaxStackSize(stack) == 1;
    }

    public int m_6473_() {
        return 5;
    }

    public void initializeClient(Consumer<IClientItemExtensions> consumer) {
        consumer.accept(new IClientItemExtensions(){

            public BlockEntityWithoutLevelRenderer getCustomRenderer() {
                return new GunItemStackRenderer();
            }
        });
    }

    public boolean m_5812_(ItemStack stack) {
        return false;
    }

    public boolean m_6832_(ItemStack pToRepair, ItemStack pRepair) {
        return pRepair.m_150930_((Item)ModItems.REPAIR_KIT.get());
    }
}

